module(...,package.seeall)

QuestManager.NewQuestQuestThread("QU667_RoboDogSoundManager")

function QU667_RoboDogSoundManager:Init()
	UsingRoboSounds = false
end

function QU667_RoboDogSoundManager:State_START_SkipTo()

end

function QU667_RoboDogSoundManager:State_START_Main()
	while true do
		coroutine.yield()
	
		local doggy = GetLocalHeroDog()
		
		if doggy:IsAlive() then
			if GraphicAppearanceMorph.IsUsingCharacterRecordWithName(doggy, "DogClockwork") then
				if not UsingRoboSounds then
					Sound.SetSoundVariableValue("SV_IS_HERO_DOG", 0)
					Sound.SetSoundVariableValue("SV_IS_ROBO_DOG", 1)
					UsingRoboSounds = true
				end
			elseif UsingRoboSounds then
				Sound.SetSoundVariableValue("SV_IS_HERO_DOG", 1)
				Sound.SetSoundVariableValue("SV_IS_ROBO_DOG", 0)
				UsingRoboSounds = false
			end
		end
	end
end


function QU667_RoboDogSoundManager:OnExit()

end
