
-- SentinelGroundSlam --
CombatSequences.SentinelGroundSlam = {}
CombatSequences.SentinelGroundSlam.Priority = SequencePriorities.Attack
CombatSequences.SentinelGroundSlam.Zones = {}
CombatSequences.SentinelGroundSlam.Zones[CombatZones.Near] = true
CombatSequences.SentinelGroundSlam.Zones[CombatZones.Middle] = true
CombatSequences.SentinelGroundSlam.Zones[CombatZones.Left] = true
CombatSequences.SentinelGroundSlam.Zones[CombatZones.Right] = true
CombatSequences.SentinelGroundSlam.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundSlam",
		FaceTargetThroughout = true,
		SpeedMultiplier = 1,
		HitOutsideAttackArc = true,
		HasPound = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		PushBackStrike = -1
	}
}

-- SentinelSpinStrike-- 
CombatSequences.SentinelSpinStrike = {}
CombatSequences.SentinelSpinStrike.Priority = SequencePriorities.Attack
CombatSequences.SentinelSpinStrike.Zones = {}
CombatSequences.SentinelSpinStrike.Zones[CombatZones.Rear] = true
CombatSequences.SentinelSpinStrike.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinStrike",
		SpeedMultiplier = 1,
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		PushBackStrike = 2
	}
}

-- SentinelWingBlast-- 
CombatSequences.SentinelWingBlast = {}
CombatSequences.SentinelWingBlast.Priority = SequencePriorities.Attack
CombatSequences.SentinelWingBlast.Zones = {}
CombatSequences.SentinelWingBlast.Zones[CombatZones.Middle] = true
CombatSequences.SentinelWingBlast.Zones[CombatZones.Far] = true
CombatSequences.SentinelWingBlast.Actions = {
	{
		Type = EScriptableAction.WING_FLAP_ATTACK,
		Anim = "WingBlast",
		FaceTargetThroughout = true,
		Strength = 5,
		MaxRange = 10,
		Angle = 30,
		DoDamage = false,
		SpeedMultiplier = 1
	}
}

-- SentinelAntiSpamWingBlast-- 
CombatSequences.SentinelAntiSpamWingBlast = {}
CombatSequences.SentinelAntiSpamWingBlast.IsValid = Predicate.CreateHasBeenHitByTargetPredicate(3)
CombatSequences.SentinelAntiSpamWingBlast.Priority = SequencePriorities.PreferredAttack
CombatSequences.SentinelAntiSpamWingBlast.CounterAttack = true
CombatSequences.SentinelAntiSpamWingBlast.Zones = {}
CombatSequences.SentinelAntiSpamWingBlast.Zones[CombatZones.Near] = true
CombatSequences.SentinelAntiSpamWingBlast.Zones[CombatZones.Middle] = true
CombatSequences.SentinelAntiSpamWingBlast.Zones[CombatZones.Far] = true
CombatSequences.SentinelAntiSpamWingBlast.Zones[CombatZones.OuterRing] = true
CombatSequences.SentinelAntiSpamWingBlast.Actions = {
	{
		Type = EScriptableAction.WING_FLAP_ATTACK,
		Anim = "WingBlast",
		FaceTargetThroughout = true,
		Strength = 5,
		MaxRange = 10,
		Angle = 30,
		DoDamage = false,
		SpeedMultiplier = 1
	}
}

-- SentinelAntiSpamGroundSlam-- 
CombatSequences.SentinelAntiSpamGroundSlam = {}
CombatSequences.SentinelAntiSpamGroundSlam.IsValid = Predicate.CreateHasBeenHitByTargetPredicate(3)
CombatSequences.SentinelAntiSpamGroundSlam.Priority = SequencePriorities.PreferredAttack
CombatSequences.SentinelAntiSpamGroundSlam.CounterAttack = true
CombatSequences.SentinelAntiSpamGroundSlam.Zones = {}
CombatSequences.SentinelAntiSpamGroundSlam.Zones[CombatZones.Near] = true
CombatSequences.SentinelAntiSpamGroundSlam.Zones[CombatZones.Middle] = true
CombatSequences.SentinelAntiSpamGroundSlam.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundSlam",
		FaceTargetThroughout = true,
		SpeedMultiplier = 1,
		HitOutsideAttackArc = true,
		HasPound = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		PushBackStrike = -1
	}
}



-- uncomment for debug
-- GUI.DisplayMessageBox("SentinelSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end