
-- GuardCloseAttack --
CombatSequences.GuardCloseAttack = {}
CombatSequences.GuardCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardCloseAttack.IsCombo = true
CombatSequences.GuardCloseAttack.Zones = {}
CombatSequences.GuardCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.GuardCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- GuardAttack --
CombatSequences.GuardAttack = {}
CombatSequences.GuardAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardAttack.IsCombo = true
CombatSequences.GuardAttack.Zones = {}
CombatSequences.GuardAttack.Zones[CombatZones.Middle] = true
CombatSequences.GuardAttack.ZonesWhilePlaying = {}
CombatSequences.GuardAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- GuardFarAttack --
CombatSequences.GuardFarAttack = {}
CombatSequences.GuardFarAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardFarAttack.IsCombo = true
CombatSequences.GuardFarAttack.Zones = {}
CombatSequences.GuardFarAttack.Zones[CombatZones.Far] = true
CombatSequences.GuardFarAttack.ZonesWhilePlaying = {}
CombatSequences.GuardFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- GuardGettingShotResponse --
CombatSequences.GuardGettingShotResponse = {}
CombatSequences.GuardGettingShotResponse.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.GuardGettingShotResponse.CounterAttack = true
CombatSequences.GuardGettingShotResponse.Priority = SequencePriorities.Attack
CombatSequences.GuardGettingShotResponse.Zones = {}
CombatSequences.GuardGettingShotResponse.Zones[CombatZones.Near] = true
CombatSequences.GuardGettingShotResponse.Zones[CombatZones.Middle] = true
CombatSequences.GuardGettingShotResponse.Zones[CombatZones.Far] = true
CombatSequences.GuardGettingShotResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- GuardOrbSuckingResponse --
CombatSequences.GuardOrbSuckingResponse = {}
CombatSequences.GuardOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.GuardOrbSuckingResponse.CounterAttack = true
CombatSequences.GuardOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.GuardOrbSuckingResponse.Zones = {}
CombatSequences.GuardOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.GuardOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.GuardOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.GuardOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- GuardEliteCloseAttack --
CombatSequences.GuardEliteCloseAttack = {}
CombatSequences.GuardEliteCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardEliteCloseAttack.IsCombo = true
CombatSequences.GuardEliteCloseAttack.Zones = {}
CombatSequences.GuardEliteCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.GuardEliteCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- GuardEliteAttack --
CombatSequences.GuardEliteAttack = {}
CombatSequences.GuardEliteAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardEliteAttack.IsCombo = true
CombatSequences.GuardEliteAttack.Zones = {}
CombatSequences.GuardEliteAttack.Zones[CombatZones.Middle] = true
CombatSequences.GuardEliteAttack.ZonesWhilePlaying = {}
CombatSequences.GuardEliteAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardEliteAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardEliteAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- GuardEliteFarAttack --
CombatSequences.GuardEliteFarAttack = {}
CombatSequences.GuardEliteFarAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardEliteFarAttack.IsCombo = true
CombatSequences.GuardEliteFarAttack.Zones = {}
CombatSequences.GuardEliteFarAttack.Zones[CombatZones.Far] = true
CombatSequences.GuardEliteFarAttack.ZonesWhilePlaying = {}
CombatSequences.GuardEliteFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardEliteFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardEliteFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardEliteFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- GuardEliteOrbSuckingResponse --
CombatSequences.GuardEliteOrbSuckingResponse = {}
CombatSequences.GuardEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.GuardEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.GuardEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.GuardEliteOrbSuckingResponse.Zones = {}
CombatSequences.GuardEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.GuardEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.GuardEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.GuardEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- GuardLieutenantCloseAttack --
CombatSequences.GuardLieutenantCloseAttack = {}
CombatSequences.GuardLieutenantCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantCloseAttack.IsCombo = true
CombatSequences.GuardLieutenantCloseAttack.Zones = {}
CombatSequences.GuardLieutenantCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenantCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- GuardLieutenantAttack --
CombatSequences.GuardLieutenantAttack = {}
CombatSequences.GuardLieutenantAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantAttack.IsCombo = true
CombatSequences.GuardLieutenantAttack.Zones = {}
CombatSequences.GuardLieutenantAttack.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenantAttack.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- GuardLieutenantFarAttack --
CombatSequences.GuardLieutenantFarAttack = {}
CombatSequences.GuardLieutenantFarAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantFarAttack.IsCombo = true
CombatSequences.GuardLieutenantFarAttack.Zones = {}
CombatSequences.GuardLieutenantFarAttack.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenantFarAttack.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- GuardLieutenantAttackOutOfBlockShort --
CombatSequences.GuardLieutenantAttackOutOfBlockShort = {}
CombatSequences.GuardLieutenantAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantAttackOutOfBlockShort.CounterAttack = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.GuardLieutenantAttackOutOfBlockShort.Zones = {}
CombatSequences.GuardLieutenantAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenantAttackOutOfBlock --
CombatSequences.GuardLieutenantAttackOutOfBlock = {}
CombatSequences.GuardLieutenantAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.GuardLieutenantAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantAttackOutOfBlock.CounterAttack = true
CombatSequences.GuardLieutenantAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.GuardLieutenantAttackOutOfBlock.Zones = {}
CombatSequences.GuardLieutenantAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenantAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenanOrbSuckingResponse --
CombatSequences.GuardLieutenanOrbSuckingResponse = {}
CombatSequences.GuardLieutenanOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.GuardLieutenanOrbSuckingResponse.CounterAttack = true
CombatSequences.GuardLieutenanOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenanOrbSuckingResponse.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.GuardLieutenanOrbSuckingResponse.Zones = {}
CombatSequences.GuardLieutenanOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenanOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenanOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenanOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenantEliteCloseAttack --
CombatSequences.GuardLieutenantEliteCloseAttack = {}
CombatSequences.GuardLieutenantEliteCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteCloseAttack.IsCombo = true
CombatSequences.GuardLieutenantEliteCloseAttack.Zones = {}
CombatSequences.GuardLieutenantEliteCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteCloseAttack.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantEliteCloseAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteCloseAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenantEliteAttack --
CombatSequences.GuardLieutenantEliteAttack = {}
CombatSequences.GuardLieutenantEliteAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteAttack.IsCombo = true
CombatSequences.GuardLieutenantEliteAttack.Zones = {}
CombatSequences.GuardLieutenantEliteAttack.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteAttack.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantEliteAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenantEliteFarAttack --
CombatSequences.GuardLieutenantEliteFarAttack = {}
CombatSequences.GuardLieutenantEliteFarAttack.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteFarAttack.IsCombo = true
CombatSequences.GuardLieutenantEliteFarAttack.Zones = {}
CombatSequences.GuardLieutenantEliteFarAttack.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteFarAttack.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantEliteFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3
	}
}

-- GuardLieutenantEliteAttackOutOfBlockShort --
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.CounterAttack = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.Zones = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- GuardLieutenantEliteAttackOutOfBlock --
CombatSequences.GuardLieutenantEliteAttackOutOfBlock = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.CounterAttack = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.Zones = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- GuardLieutenantEliteOrbSuckingResponse --
CombatSequences.GuardLieutenantEliteOrbSuckingResponse = {}
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Zones = {}
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.GuardLieutenantEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}



-- uncomment for debug
-- GUI.DisplayMessageBox("GuardSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end